package gov.va.med.mhv.bluebutton.web.bean;

import gov.va.med.mhv.integration.phr.transfer.FacilityExtractStatus;
import gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.bean.ManagedBean;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("session")
public class PhrStatusBean implements Serializable {
	private static final long serialVersionUID = -4455323209252190285L;

	private PatientExtractStatus status;

	private Boolean isRefreshCompleteForImaging = false;
	private Boolean isRefreshComplete = false;
	private Boolean isRefreshNeeded = true;
	private Boolean isChampVAUser = false;
	private Boolean isChampVAVeteranUser = false;
	private Boolean isAdvancedUser = false;
	
	@Autowired
	private BlueButtonFormBean form;
	
	private static Map<String,FacilityExtractStatus> allExtracts = new HashMap<String,FacilityExtractStatus>();
	static {
		allExtracts.put("WellnessReminders",null);
		allExtracts.put("DodMilitaryService",null);
		allExtracts.put("Appointments",null);
		allExtracts.put("Allergy",null);
		allExtracts.put("ChemistryHematology",null);
		allExtracts.put("ImagingStudy",null);
		allExtracts.put("VPR",null);
	}
	
	private static Map<String,Integer> extractTimes = new HashMap<String,Integer>();
	static {
		extractTimes.put("WellnessReminders",1); //10 seconds
		extractTimes.put("DodMilitaryService",1); //13 seconds
		extractTimes.put("Appointments", 1); //34 seconds
		extractTimes.put("Allergy", 1); //12 seconds
		extractTimes.put("ChemistryHematology",1); //24 seconds
		extractTimes.put("ImagingStudy",1); //42
		extractTimes.put("VPR",1); //40
	}
	
	public BlueButtonFormBean getForm() {
		return form;
	}

	public void setForm(BlueButtonFormBean form) {
		this.form = form;
	}

	public boolean getIsRefreshCompleteForImaging() {
		return isRefreshCompleteForImaging;
	}

	public void setIsRefreshCompleteForImaging(Boolean isRefreshCompleteForImaging) {
		this.isRefreshCompleteForImaging = isRefreshCompleteForImaging;
	}

	public boolean getIsRefreshComplete() {
		return isRefreshComplete;
	}

	public void setIsRefreshComplete(Boolean isRefreshComplete) {
		this.isRefreshComplete = isRefreshComplete;
	}

	public boolean getIsRefreshNeeded() {
		return isRefreshNeeded;
	}

	public void setIsRefreshNeeded(Boolean isRefreshNeeded) {
		this.isRefreshNeeded = isRefreshNeeded;
	}

	public PatientExtractStatus getPatientExtractStatus() {
		return status;
	}

	public void setPatientExtractStatus(PatientExtractStatus status) {
		
		if( status != null && !status.getFacilityExtractStatusList().isEmpty() ) {
			this.status = status;
		}
		
		//Compile and set the statuses once
		this.setIsRefreshComplete(getRefreshComplete());
		this.setIsRefreshCompleteForImaging(getRefreshComplete("ImagingStudy") && getRefreshComplete("VPR"));
	}

	/**
	 * Check if inProgress and was it updated today?
	 * 
	 * @return
	 */
	private boolean getRefreshComplete() {
		boolean isComplete = false;
		if( status != null && status.getFacilityExtractStatusList() != null) {
			for (FacilityExtractStatus facilityExtractStatus : status.getFacilityExtractStatusList()) {
				if( facilityExtractStatus.getExtract().trim().equalsIgnoreCase("ImagingStudy") ) {
					//Don't count imaging as part of the full data refresh
					continue;
				}
				
				if( facilityExtractStatus.getLoadStatus() == null ) {
					isComplete = false;
					break;
				}
				else if( facilityExtractStatus.getLoadStatus() != null && !facilityExtractStatus.getLoadStatus().equals("OK") ) {
					isComplete = false;
					break;
				}
			}
		}
		return isComplete;
	}

	/**
	 * Check if inProgress and was it updated today?
	 * 
	 * If the load status is null (means in progress)
	 * Or 'NEW' it is in progress
	 * 
	 * @return
	 */
	private boolean getRefreshComplete(String extract) {
		boolean isComplete = false;
		if (status != null && status.getFacilityExtractStatusList() != null) {
			for (FacilityExtractStatus facilityExtractStatus : status.getFacilityExtractStatusList()) {
				if( facilityExtractStatus.getExtract().equals(extract) &&
					facilityExtractStatus.getLoadStatus() != null && 
					facilityExtractStatus.getLoadStatus().equals("OK") ) {
						isComplete = true;
						break;
				}
			}
		}
		return isComplete;
	}
	
	public Date getLastModifiedForBBMI() {
		return getLastModifiedForExtract("ImagingStudy");
	}
	
	private Date getLastModifiedForExtract(String extract) {
		Date response = new Date();
		if (status != null && status.getFacilityExtractStatusList() != null) {
			for (FacilityExtractStatus s : status.getFacilityExtractStatusList()) {
				if (s.getExtract().trim().equalsIgnoreCase(extract)) {
					if (s.getLastModified() != null) {
						response = s.getLastModified();
						break;
					}
				}
			}
		}
		return response;
	}
	
	private String computeLastUpdateString(SimpleDateFormat s, FacilityExtractStatus f ) {
		StringBuffer sb = new StringBuffer();
		if( f != null && f.getLastSuccessfulCompleted() != null ) {
			sb.append(" (Last Updated ").append(s.format(f.getLastSuccessfulCompleted())).append(")");
		} else {
			sb.append(""); //TODO TBD
		}
			
		return sb.toString();
	}
	
	public List<String> getDomainsSelectedSuccess() {
		form.checkSelectForTypesOfInformation(getIsAdvancedUser(), getIsChampVAUser(), getIsChampVAVeteranUser());
		Map<String,FacilityExtractStatus> extracts = new HashMap<String,FacilityExtractStatus>();
		if(status != null) {
			for( FacilityExtractStatus fes: status.getFacilityExtractStatusList())  {
				if( fes.getLoadStatus().equals("OK") ) {
					extracts.put(fes.getExtract(),fes);
				}
			}
		}
		List<String> domains = generateDomainList(extracts);
		Collections.sort(domains);
		return domains;
	}
	
	public List<String> getDomainsSelectedInProgress() {
		form.checkSelectForTypesOfInformation(getIsAdvancedUser(), getIsChampVAUser(), getIsChampVAVeteranUser());
		Map<String,FacilityExtractStatus> extracts = new HashMap<String,FacilityExtractStatus>();
		if(status != null) {
			//If the users PHR status is REFRESH the list will be empty for statuses
			if( !status.getFacilityExtractStatusList().isEmpty() ) {
				for( FacilityExtractStatus fes: status.getFacilityExtractStatusList())  {
					if( fes.getLoadStatus()==null || fes.getLoadStatus().equals("NEW") ) {
						extracts.put(fes.getExtract(),fes);
					}
				}
			} else {
				//Since all are unknown we consider them in progress
				extracts = allExtracts;
			}
		}
		List<String> domains = generateDomainList(extracts);
		Collections.sort(domains);
		return domains;
	}
	
	public List<String> getDomainsSelectedError() {
		form.checkSelectForTypesOfInformation(getIsAdvancedUser(), getIsChampVAUser(), getIsChampVAVeteranUser());
		Map<String,FacilityExtractStatus> extracts = new HashMap<String,FacilityExtractStatus>();
		if(status != null) {
			for( FacilityExtractStatus fes: status.getFacilityExtractStatusList())  {
				if( fes.getLoadStatus()!=null && fes.getLoadStatus().equals("ERROR") ) {
					extracts.put(fes.getExtract(),fes);
				}
			}
		}
		List<String> domains = generateDomainList(extracts);
		Collections.sort(domains);
		
		return domains;
	}
	
	private List<String> generateDomainList(Map<String,FacilityExtractStatus> extracts) {
		List<String> domains = new ArrayList<String>();
		SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy @ HHmm 'ET'");
		
		if(extracts.containsKey("Allergy") && (form.isVaallergies() || form.isAllallergies()) ) {
			domains.add("VA Allergies" + computeLastUpdateString(sdf, extracts.get("Allergy")) );
		}
		
		if(extracts.containsKey("Appointments") && ( ( form.isPastappointments() || form.isFutureappointments() ) || form.isAllappointments()) ) {
			domains.add("VA Appointments" + computeLastUpdateString(sdf, extracts.get("Appointments")));
		}
		
		if(extracts.containsKey("WellnessReminders") && (form.isWellness() || form.isAllelectronic()) ) {
			domains.add("VA Wellness Reminders" + computeLastUpdateString(sdf, extracts.get("WellnessReminders")));
		}
		
		if (extracts.containsKey("ChemistryHematology") && (form.isVachemlabs() || form.isAlllabs() ))  {
			domains.add("VA Laboratory Results: Chemistry/Hematology" + computeLastUpdateString(sdf, extracts.get("ChemistryHematology")));
		} 
		
		if(extracts.containsKey("VPR") && (form.isVachemlabs() || form.isAlllabs()) ) {
			domains.add("VA Laboratory Results: Microbiology" + computeLastUpdateString(sdf, extracts.get("VPR")));
		}
		
		if(extracts.containsKey("DodMilitaryService") && form.isDodmilitaryservice()) {
			domains.add("Department of Defense Military Service Information" + computeLastUpdateString(sdf, extracts.get("DodMilitaryService")));
		}
		
		if(extracts.containsKey("VPR")) {
			if( (form.isVaadmissionsanddischarges() || form.isAllelectronic()) )
				domains.add("VA Admissions and Discharges" + computeLastUpdateString(sdf, extracts.get("VPR")));
			
			if( (form.isVademographics() || form.isAlldemographics()) )
				domains.add("VA Demographics"  + computeLastUpdateString(sdf, extracts.get("VPR")));
			
			if( (form.isVaekg() || form.isAlllabs() ) )
				domains.add("VA Electrocardiogram (EKG)" + computeLastUpdateString(sdf, extracts.get("VPR")));
			
			if( (form.isVaimmunizations() || form.isAllimmunizations()) )
				domains.add("VA Immunizations" + computeLastUpdateString(sdf, extracts.get("VPR")));
			
			if( (form.isVapathology() || form.isAlllabs()) )
				domains.add("VA Pathology Reports: Surgical Pathology/Cytology/Electron Microscopy" + computeLastUpdateString(sdf, extracts.get("VPR")));
			
			if( (form.isVaproblemlist() || form.isAllelectronic() ))
				domains.add("VA Problem List" + computeLastUpdateString(sdf, extracts.get("VPR")));
			
			if( (form.isVaprogressnotes() || form.isAllelectronic()) )
				domains.add("VA Notes" + computeLastUpdateString(sdf, extracts.get("VPR")));
			
			if( (form.isVaradiology() || form.isAlllabs()) )
				domains.add("VA Radiology" + computeLastUpdateString(sdf, extracts.get("VPR")));
			
			if( (form.isVavitals() || form.isAllvitals()) )
				domains.add("VA Vitals and Readings" + computeLastUpdateString(sdf, extracts.get("VPR")));
		}
		
		return domains;
	}
	
	public Date getLastRefreshCompleteDateForImagingAsDate() {
		Date img = null, vpr = null;
		if( status != null && status.getFacilityExtractStatusList() != null ) {
			for( FacilityExtractStatus fes: status.getFacilityExtractStatusList())  {
				if(fes.getExtract().equals("ImagingStudy")) {
					img = fes.getLastSuccessfulCompleted();
					continue;
				} 
				if(fes.getExtract().equals("VPR")) {
					vpr = fes.getLastSuccessfulCompleted();
					continue;
				}
			}
		}
		
		if( img != null && vpr != null ) {
			Date last = (img.before(vpr) ? vpr:img);
			return last;
		}
		
		return null;
	}
	
	public String getLastRefreshCompleteDateForImaging() {
		//01/04/2018 at 10:46
		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy @ HHmm");
		Date img = null;
		Date vpr = null;
		if( status != null && status.getFacilityExtractStatusList() != null ) {
			for( FacilityExtractStatus fes: status.getFacilityExtractStatusList())  {
				if(fes.getExtract().equals("ImagingStudy")) {
					img = fes.getLastSuccessfulCompleted();
					continue;
				} 
				
				if(fes.getExtract().equals("VPR")) {
					vpr = fes.getLastSuccessfulCompleted();
					continue;
				}
			}
		}
		
		StringBuffer sb = new StringBuffer();
		if( img != null && vpr != null ) {
			Date latest = (img.before(vpr) ? vpr:img);
			sb.append("Your VA Medical Imaging and Reports Information was last updated in My HealtheVet on ").append(sdf.format(latest)).append(" ET.");
		} else {
			sb.append(""); //TODO No last updated value to return
		}
			
		return sb.toString();
	}
	
	public List<String> getImagingDomain() {
		List<String> domains = new ArrayList<String>();
		domains.add("VA Medical Imaging and Reports");
		return domains;
	}
	
	public String getDebugStatus() {
		StringBuffer sb = new StringBuffer();
		int i = 0;
		for (FacilityExtractStatus f : status.getFacilityExtractStatusList() ) {
			sb.append("FacilityExtractStatus["+(i++)+"]: getExtract=" + f.getExtract() + ",getLoadStatus=" + f.getLoadStatus() + ",getLastRequested=" + f.getLastRequested() + ",getLastCompleted=" + f.getLastCompleted() + "\n");
		}
		return sb.toString();
	}

	public Boolean getIsAdvancedUser() {
		return isAdvancedUser;
	}

	public void setIsAdvancedUser(Boolean isAdvancedUser) {
		this.isAdvancedUser = isAdvancedUser;
	}

	public Boolean getIsChampVAUser() {
		return isChampVAUser;
	}

	public void setIsChampVAUser(Boolean isChampVAUser) {
		this.isChampVAUser = isChampVAUser;
	}

	public Boolean getIsChampVAVeteranUser() {
		return isChampVAVeteranUser;
	}

	public void setIsChampVAVeteranUser(Boolean isChampVAVeteranUser) {
		this.isChampVAVeteranUser = isChampVAVeteranUser;
	}

}


